﻿<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>

<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Towary" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Magazyny" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Types" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Stany magazynowe</title>
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">

    <script runat="server">
        
    void dc_ContextLoad(object sender, EventArgs args)
	{
        ObrotyParams op = dc.Context[typeof(ObrotyParams), false] as ObrotyParams;
        checkObrotyPars(op);                        
        this.ReportHeader.Title += WydrukiTools.WydrukiStanyMagazynoweLista.FilterInfo(op);
	}

    private void checkObrotyPars(ObrotyParams pars) {
        if (pars == null)
            throw new ArgumentNullException("ObrotyParams pars");
        if (pars.Magazyny == null || (pars.Magazyny != null && pars.Magazyny.Length == 0))
            throw new InvalidOperationException("Wymagane jest wybranie przynajmniej jednego magazynu.");
    }
    
    
    </script>

	</HEAD>
	<body>
		<form method="post" runat="server">
			<ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" runat="server" title="Stany magazynowe|</STRONG>"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" RowTypeName="Soneta.Towary.Towar,Soneta.Handel">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp." runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Width="14" Align="Left" DataMember="Kod" Caption="Towar~Kod" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Align="Left" DataMember="Nazwa" Total="Info" Caption="Towar~Nazwa" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="11" Align="Right" DataMember="Workers.StanMagazynu.StanMagazynu" Caption="Magazyn~Ilość"
						runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Width="12" Align="Right" DataMember="Workers.StanMagazynu.WartośćMagazynu" Total="Sum"
						Caption="Magazyn~Wartość" Format="{0:n}" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Width="11" Align="Right" DataMember="Workers.StanMagazynu.StanZam&#243;wieńMagazynowych" Caption="Zam&#243;wienia~Ilość"
						runat="server" EncodeHTML="True"></ea:GridColumn>
                    <ea:GridColumn runat="server" Align="Right" Caption="Zam&#243;wienia~Wartość" DataMember="Workers.StanMagazynu.WartośćZam&#243;wieńMagazynowych"
                        EncodeHTML="True" Format="{0:n}" Total="Sum" Width="12">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Align="Right" Caption="Suma" DataMember="Workers.StanMagazynu.WartośćKsięgowaMagazynu"
                        EncodeHTML="True" Format="{0:n}" Total="Sum" Width="13">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Align="Right" Caption="Ilość|minus" DataMember="Workers.StanMagazynu.StanMinus"
                        EncodeHTML="True" Format="{0:n}" Width="10">
                    </ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server" PrintDate="true" PrintTime="true"></eb:ReportFooter>
		</form>
	</body>
</HTML>

